 aR  w - mP9      h	 o       nSystem-wide%SET (supportsEmsWindows, 0)
$NOLIST

NAME  ScreenLineRoutines

CGROUP GROUP CODE

EXTRN	screenSeg: ABS
EXTRN	RotatePtsNorth: NEAR, InitWinParms: NEAR, StartPosition: NEAR

%IF (%supportsEmsWindows EQ 1) THEN (
EXTRN	RestoreEmsSlot: NEAR
) FI

PUBLIC  ScrTestPixel, ScrLineRoutine, ScrHLineRoutine


zero        EQU  0
true        EQU  0FFFFH         

pelsPerWord EQU  16

; This is a little slimy trick I learned from Bill Gates of Microsoft fame.
; When placed before a two byte instruction it effectively skips that
; instruction and is about four times faster than a SHORT JMP instruction.

%*DEFINE (SkipNextInstrCX)
 (DB 0B9H)
$EJECT

CODE SEGMENT PUBLIC 'CODE'
ASSUME  CS:CGROUP

;**************************************************
;*
;*    ScrTestPixel (screen, winWidth, winHeight, x, y: Word)
;*
;* This will test the pixel at point (X,Y) and will
;* return TRUE if it is set, else it will return FALSE
;*
;**************************************************

;  Params for ScrTestPixel

params STRUC
  oldDS        DW  ?
  oldBp        DW  ?
;-----------
  returnIP     DW  ?
  returnCS     DW  ?
;-----------
  y            DW  ?
  x            DW  ?
  winHeight    DW  ?
  bytesPerLine DW  ?	; Passed in as winWidth
  screen       DW  ?
params ENDS

loc        EQU [BP]
paramBytes EQU 10

ScrTestPixel PROC FAR
	PUSH	BP
	PUSH	DS
	MOV	BP, SP

;*;*;* This change is needed to use the display in portrait mode

	MOV	AX, loc.x	; x
	MOV	BX, loc.y	; y
	MOV	CX, 1	; width of pt is 1 (Aleady set above)
	MOV	SI, CX	; height of pt is 1 (Aleady set above)
	MOV	DX, loc.bytesPerLine	; Really winWidth at this point
	MOV	DI, loc.winHeight

	CALL	RotatePtsNorth

	MOV	loc.x, AX
	MOV	loc.y, BX

;*;*;* End of change

; DX (Now converted to bytesPerLine) and DI preserved by RotatePtsNorth

	MOV	AX, loc.screen

	CALL	InitWinParms
	MOV	DS, AX

	MOV	AX, loc.y
	MOV	BX, loc.x

	CALL	StartPosition

%IF (%supportsEmsWindows EQ 1) THEN (
	MOV	BX, SI	; save ems slot in BX
) FI

	MOV	SI, 0080H
	ROR	SI, CL	; rotate to position

	MOV	AX, DS:[DI]	; Get the word
	AND	AX, SI	; Mask out all other bits
	JZ	NotSet	; do nothing if not set

	MOV	AX, true	; Set to true if bit is set.

NotSet:
%IF (%supportsEmsWindows EQ 1) THEN (
	INC	BX	; if old ems slot = -1
	JZ	ScrTestPixelRet	; then don't restore

	PUSH	AX
	DEC	BX	; ems slot
	XCHG	AX, BX	; passed in AX
	CALL	RestoreEmsSlot	; this call preserves BX
	POP	AX
) FI

ScrTestPixelRet:
	POP	DS
	POP	BP
	RET	paramBytes
ScrTestPixel ENDP

  PURGE params
  PURGE oldBP
  PURGE oldDS
  PURGE returnIP
  PURGE returnCS
  PURGE x
  PURGE y
  PURGE bytesPerLine
  PURGE screen
  PURGE loc
  PURGE paramBytes
  PURGE winHeight
$EJ

;*********************************************************
;*
;* ScrLineRoutine (screen, winWidth, winHeight, x1, y1, x2, y2, grafVerb)
;*
;* This will draw a line between the two points (x1, y1) and
;* (x2, y2).  It uses the DDA algorithm.  The act of
;* drawing a line is split into two cases for efficiency.
;*
;*  case AB: dx >= dy
;*  case CD: dx < dy
;*
;* During the inner loop of each case, the registers mean:
;*
;*  AX = dx            BX = dy
;*  CX = loop counter  DX = temp
;*  SI = mask          DI ^ display buffer
;*  BP = +- wordWidth
;*
;********************************************************

;  Params for ScrLineRoutine

params STRUC
	lineVerbRtn   DW  ?
  bplLessRewind DW  ?
  adjustDelta   DW  ?
  rewindDelta   DW  ?
  edge          DB  ?
  oddlineFlag   DB  ?
;-----------
  oldDS         DW  ?
  oldBp         DW  ?
;-----------
  returnIP      DW  ?
  returnCS      DW  ?
;-----------
  lineVerb      DW  ?
	ptnByte1      DB  ?
	ptnByte2      DB  ?
	ptnByte3      DB  ?
	ptnByte4      DB  ?
	ptnByte5      DB  ?
	ptnByte6      DB  ?
	ptnByte7      DB  ?
	ptnByte8      DB  ?
  y2            DW  ?
  x2            DW  ?
  y1            DW  ?
  x1            DW  ?
  winHeight     DW  ?
  bytesPerLine  DW  ?	; Passed in as winWidth
  screen        DW  ?
params ENDS

localBytes EQU 10
loc        EQU [BP-localBytes]
paramBytes EQU 24

sizeOfLineVerbTable EQU 8

FirstVerbTable  LABEL WORD
  DW   OFFSET FirstDraw
  DW   OFFSET FirstErase
  DW   OFFSET FirstInvert
  DW   OFFSET FirstDraw	; Merge is the same as Draw

CaseABVerbTable LABEL WORD
  DW   OFFSET CaseABDraw
  DW   OFFSET CaseABErase
  DW   OFFSET CaseABInvert
  DW   OFFSET CaseABDraw	; Merge is the same as Draw

CaseCDVerbTable LABEL WORD
  DW   OFFSET CaseCDDraw
  DW   OFFSET CaseCDErase
  DW   OFFSET CaseCDInvert
  DW   OFFSET CaseCDDraw	; Merge is the same as Draw


; NOTE: This routine currently doesn't handle patterns, but could if
; modified like the ScrHLineRoutine below.

ScrLineRoutine PROC FAR
  PUSH BP
  PUSH DS
  MOV  BP, SP
  SUB  SP,localBytes

	MOV	AX, loc.lineVerb
	AND	AX, 3	; Only allow draw, erase, invert & merge
  SHL  AX, 1
  MOV  loc.lineVerb, AX

;*;*;* This change is needed to use the display in portrait mode

  MOV  AX, loc.x2	; x2
  MOV  BX, loc.y2	; y2
	MOV	CX, 1	; width of pt is 1
	MOV	SI, CX	; height of pt is 1
	MOV  DX, loc.bytesPerLine	; Really winWidth at this point
	MOV  DI, loc.winHeight

	CALL	RotatePtsNorth

	PUSH	AX
	PUSH	BX

  MOV  AX, loc.x1	; x1
  MOV  BX, loc.y1	; y1
;	MOV	CX, 1	; width of pt is 1 (Aleady set above)
;	MOV	SI, CX	; height of pt is 1 (Aleady set above)
	MOV  DX, loc.bytesPerLine	; Really winWidth at this point
	MOV  DI, loc.winHeight

	CALL	RotatePtsNorth

	MOV  loc.bytesPerLine, DX	; Now it is actually bytesPerLine
;	MOV  loc.winHeight, DI	; This will be resaved after InitWinParms

	POP	DX
	POP	CX

;*;*;* End of change

  CMP  AX, CX               ; x1 <= x2 ?
  JLE  Line10

  XCHG AX, CX
  XCHG BX, DX               ; now x1 <= x2

Line10:
  SUB  CX, AX               ; CX = dx ( >= 0)
  SUB  DX, BX               ; DX = dy

  PUSH CX                     ; save dx for later
  PUSH DX                     ; save dy for later

  PUSH AX                     ; save x pos for later
  PUSH BX                     ; save y pos for later

; DI still set from above

  MOV  AX, loc.screen
	MOV	DX, loc.bytesPerLine

  CALL InitWinParms

  MOV  DS, AX
  MOV  loc.edge, CL
  MOV  loc.rewindDelta, BX
  MOV  loc.winHeight, DI

  POP  AX	; y Pos
  POP  BX	; x Pos
  CALL StartPosition

  MOV  loc.adjustDelta, DX	; adjustDelta same as bytesPerLine,
  MOV  loc.oddLineFlag, AL	; except below

  POP  BX	; BX = dy
  POP  AX	; AX = dx

  CMP  BX, zero
  JGE  Line20	; dy >= 0

  NEG  BX	; dy = |dy|

  ADD  loc.winHeight, DX	; need to round up for backwards case
  NEG  loc.winHeight	; want to be doing the opposite with
  NEG  loc.bytesPerLine	; all of these since the line is being
  NEG  loc.rewindDelta	; drawn from bottom to top

  NOT  loc.oddLineFlag
  AND  loc.oddLineFlag, 11b	; oddLineFlag = (3 - oddLineFlag)

  NOT  loc.edge
  AND  loc.edge, 11b	; edge = (3 - edge)

Line20:
%IF (%supportsEmsWindows EQ 1) THEN (
  PUSH SI	; Save old EMS slot
) FI

  MOV  SI, 0080H	; SI = original mask
  ROR  SI, CL	; rotate to starting pos

  MOV  CX, loc.bytesPerLine
  SUB  CX, loc.rewindDelta
  MOV  loc.bplLessRewind, CX

  XCHG BX, CX	; Save BX in CX
  MOV  BX, OFFSET FirstVerbTable
  ADD  BX, loc.lineVerb
	MOV  DX, BX	; Save offset to first verb addr in DX
  MOV  BX, CS:[BX]
	XCHG CX, BX	; Restore BX
  JMP  CX

FirstErase:
  NOT  SI
  AND  DS:[DI], SI	; clear the bit
  NOT  SI
  %SkipNextInstrCX	; MOV CX that "eats" the XOR DS:[DI], SI

FirstInvert:
  XOR  DS:[DI], SI	; invert the bit
  %SkipNextInstrCX	; MOV CX that "eats" the OR DS:[DI], SI

FirstDraw:
  OR   DS:[DI], SI	; set the bit

  CMP  AX, BX	; dx < dy ?
  JL   CaseCD	; yes -> case CD
$EJECT

CaseAB:	; *** CASE AB ***
  XCHG DX, BX	; DX has offset to first verb
	ADD  BX, sizeOfLineVerbTable
  MOV  BX, CS:[BX]
	MOV	loc.lineVerbRtn, BX
	MOV  BX, DX	; Restore BX

  MOV  CX, AX	; loop 'dx' times
  MOV  DX, AX
  CMP  DX, 1
  JLE  CaseABNoShift

  SAR  DX, 1

CaseABNoShift:
  NEG  DX	; DX = -dx/2; DX > 0!!
  JCXZ CaseABDone

CaseABLoop:
  MOV	ES, CX	; Save count in ES
  ADD  DX, BX	; temp = temp + dy
  JS   CaseAB10

  SUB  DX, AX	; temp = temp - dx

  MOV  CL, loc.oddLineFlag
  INC  CL
  AND  CL, 3
  JNZ  CaseABNextBuffer

  ADD  DI, loc.bplLessRewind
  JMP  SHORT CaseABAdjustDone

CaseABNextBuffer:
  ADD  DI, loc.winHeight
  CMP  CL, loc.edge
  JA   CaseABAdjustDone

  ADD  DI, loc.adjustDelta

CaseABAdjustDone:
  MOV  loc.oddLineFlag, CL

CaseAB10:
  ROR  SI, 1	; x += 1
  TEST SI, 80H
  JZ   CaseABSameX

  INC  DI
  INC  DI	; DI ^ next word

CaseABSameX:
  JMP  loc.lineVerbRtn

CaseABErase:
  NOT  SI
  AND  DS:[DI], SI	; clear the bit
  NOT  SI
  %SkipNextInstrCX	; MOV CX that "eats" the XOR DS:[DI], SI

CaseABInvert:
  XOR  DS:[DI], SI	; invert the bit
  %SkipNextInstrCX	; MOV CX that "eats" the OR DS:[DI], SI

CaseABDraw:
  OR   DS:[DI], SI	; set the bit

  MOV  CX, ES	; Restore count from ES
  LOOP CaseABLoop

CaseABDone:
  JMP  SHORT LoopDone
$EJECT

CaseCD:	; *** CASE CD ***
  XCHG DX, BX	; DX has offset to first verb
	ADD  BX, sizeOfLineVerbTable + sizeOfLineVerbTable
  MOV  BX, CS:[BX]
	MOV	loc.lineVerbRtn, BX
	MOV  BX, DX	; Restore BX

  MOV  CX, BX	; loop 'dy' times
  MOV  DX, BX
  CMP  DX, 1
  JLE  CaseCDNoShift

  SAR  DX, 1

CaseCDNoShift:
  NEG  DX	; DX = -dy / 2
  JCXZ LoopDone

CaseCDLoop:
  MOV  ES, CX	; Save count in ES
  ADD  DX, AX	; temp = temp + dx
  JS   CaseCD10

  SUB  DX, BX	; temp = temp - dy
  ROR  SI, 1	; x += 1
  TEST SI, 80H
  JZ   CaseCD10

  INC  DI
  INC  DI	; DI ^ next word

CaseCD10:
  MOV  CL, loc.oddLineFlag
  INC  CL
  AND  CL, 3
  JNZ  CaseCDNextBuffer

  ADD  DI, loc.bplLessRewind
  JMP  SHORT CaseCDAdjustDone

CaseCDNextBuffer:
  ADD  DI, loc.winHeight
  CMP  CL, loc.edge
  JA   CaseCDAdjustDone

  ADD  DI, loc.adjustDelta

CaseCDAdjustDone:
  MOV  loc.oddLineFlag, CL

  JMP  loc.lineVerbRtn

CaseCDErase:
  NOT  SI
  AND  DS:[DI], SI	; clear the bit
  NOT  SI
  %SkipNextInstrCX	; MOV CX that "eats" the XOR DS:[DI], SI

CaseCDInvert:
  XOR  DS:[DI], SI	; invert the bit
  %SkipNextInstrCX	; MOV CX that "eats" the OR DS:[DI], SI

CaseCDDraw:
  OR   DS:[DI], SI	; set the bit

CaseCDBottom:
  MOV  CX, ES	; Restore count from ES
  LOOP CaseCDLoop

LoopDone:
%IF (%supportsEmsWindows EQ 1) THEN (
  POP  AX	; Restore EMS slot
  INC  AX
  JZ   ScrLineVerbRet

  DEC  AX
  CALL RestoreEmsSlot
) FI

ScrLineVerbRet:
  MOV  SP,BP
  POP  DS
  POP  BP
  RET  paramBytes
ScrLineRoutine ENDP

  PURGE params
  PURGE oldBP
  PURGE oldDS
  PURGE returnIP
  PURGE returnCS
  PURGE x1
  PURGE x2
  PURGE y1
  PURGE y2
  PURGE bytesPerLine
  PURGE screen
  PURGE loc
  PURGE localBytes
  PURGE paramBytes
  PURGE winHeight
  PURGE oddLineFlag
  PURGE edge
  PURGE rewindDelta
  PURGE adjustDelta
  PURGE bplLessRewind
  PURGE lineVerb
	PURGE lineVerbRtn
	PURGE ptnByte1, ptnByte2, ptnByte3, ptnByte4
	PURGE ptnByte5, ptnByte6, ptnByte7, ptnByte8
$EJECT

;  Params for ScrHLineRoutine

params STRUC

hLinePtnRtn   DW  ?
hLineRoutine  DW  ?
curPattern    DW  ?
curPtnOffset  DW  ?
bplLessRewind DW  ?
rewindDelta   DW  ?
edge          DB  ?
oddLineFlag   DB  ?
;-----------
oldBp         DW  ?
oldDs         DW  ?
returnIP      DW  ?
returnCS      DW  ?
;-----------
hLineVerb     DW  ?
ptnByte1      DB  ?
ptnByte2      DB  ?
ptnByte3      DB  ?
ptnByte4      DB  ?
ptnByte5      DB  ?
ptnByte6      DB  ?
ptnByte7      DB  ?
ptnByte8      DB  ?
numLines      DW  ?
w             DW  ?	; width
x             DW  ?
y             DW  ?
windowHeight  DW  ?
bytesPerLine  DW  ?	; Passed in as windowWidth
screen        DW  ?
params ENDS

localBytes EQU 14
loc        EQU [BP-localBytes]
paramBytes EQU 24

; ES:DI points to the screen
; SI is offset to start of current line
; BX = last word mask
; DX = # words in middle of line
; DS = first word mask

; Transfer modes are defined as follow:
;
; draw=0, erase=1, invert=2, merge=3
; ptn draw=4, ptn erase=5, ptn invert=6, ptn merge=7

HLineVerbTable LABEL WORD
  DW   OFFSET HLineDraw
  DW   OFFSET HLineErase
  DW   OFFSET HLineInvert
  DW   OFFSET HLineDraw	; Merge is the same as draw for solid line
	DW	OFFSET HLinePtnRtns

HLinePtnVerbTable LABEL WORD
	DW	OFFSET HLinePtnDraw
	DW	OFFSET HLinePtnErase
	DW	OFFSET HLinePtnInvert
	DW	OFFSET HLinePtnMerge

ScrHLineRoutine PROC FAR
  PUSH DS
  PUSH BP
  MOV  BP, SP
  SUB  SP, localBytes

	MOV	BX, loc.hLineVerb
	CMP	BX, 4
	JB	SetLineVerbRtn

	MOV	BX, 4	; All pattern rtns go thru HLinePtnRtns

SetLineVerbRtn:
	SHL	BX, 1
	MOV	AX, CS:[OFFSET HLineVerbTable+BX]
	MOV	loc.hLineRoutine, AX

;*;*;* This change is needed to use the display in portrait mode

  MOV  AX, loc.x
  MOV  BX, loc.y
  MOV  CX, loc.w
  MOV  SI, loc.numLines
  MOV  DX, loc.bytesPerLine	; Really windowWidth at this point
  MOV  DI, loc.windowHeight

	CALL	RotatePtsNorth

  MOV  loc.x, AX
  MOV  loc.y, BX
  MOV  loc.w, CX
  MOV  loc.numLines, SI
  MOV  loc.bytesPerLine, DX	; Now it is really bytesPerLine
;	MOV  loc.windowHeight, DI	; This is reset again after InitWinParms

;*;*;* End of change

; Set up pattern specific variables if needed

	MOV	BX, loc.hLineVerb
	CMP	BX, 4
	JB	NotPatternCase

	AND	BX, 3	; Only valid modes are 0 to 3
	SHL	BX, 1
	MOV	BX, CS:[OFFSET HLinePtnVerbTable+BX]
	MOV	loc.hLinePtnRtn, BX

	MOV	BX, loc.y
	AND	BX, 7	; Get index into pattern array
	MOV	loc.curPtnOffset, BX

; DX and DI returned by RotatePtsNorth

NotPatternCase:
  MOV  AX, loc.screen

  CALL InitWinParms

  MOV  ES, AX
  MOV  loc.edge, CL
  MOV  loc.rewindDelta, BX
  MOV  loc.windowHeight, DI

%IF (%supportsEmsWindows EQ 1) THEN (
  PUSH SI	; save old ems slot (if swapped)
) FI

; CX, DX and DI set by InitWinParms

  MOV  AX, loc.y
  MOV  BX, loc.x
  CALL StartPosition	; calculate where to start
  MOV  loc.oddLineFlag, AL

; Precalculate this to make the main loop faster

  MOV  AX, loc.bytesPerLine
  SUB  AX, loc.rewindDelta
  MOV  loc.bplLessRewind, AX

;first word
  MOV  BX, pelsPerWord	; example CX = 4
  SUB  BX, CX	; # pels to end of word
  MOV  AX, 0FFFFH
  SHR  AX, CL	; 0000 1111 1111 1111
  MOV  CX, BX
  SUB  CX, loc.w
  JLE  HLineDoFirst

;fits in one word
  SHR  AX, CL
  SHL  AX, CL
  XCHG AL, AH	; bytes are bytewide on PC
  MOV  DS, AX	; first mask
  XOR  DX, DX	; middle count := 0
  MOV  BX, DX	; last mask := 0
  JMP  SHORT HLineEpilogue

HLineDoFirst:
  XCHG AL, AH	; bytes are backwards on PC
  MOV  DS, AX	; first mask

HLineMiddle:
  MOV  AX, loc.w
  SUB  AX, BX	; bits already done
  MOV  BX, AX	; bit count
	SHR	AX, 1
	SHR	AX, 1
	SHR	AX, 1
	SHR	AX, 1
  MOV  DX, AX	; word count for middle

  AND  BX, 0FH	; example BX = 6
  MOV  CX, pelsPerWord
  SUB  CX, BX	; CX = 10
  MOV  BX, 0FFFFH
  SHL  BX, CL	; 1111 1100 0000 0000
  XCHG BL, BH	; bytes are backwards on Pc

HLineEpilogue:
  CLD		; clear direction
  MOV  CX, loc.numLines	; get # of lines
  MOV  SI, DI	; SI is offset to start of line

HLineTopOfLoop:
  PUSH CX	; save the current count

  MOV  DI, SI	; DI := offset of next line
  MOV  AX, DS	; AX := first mask

	JMP  loc.hLineRoutine


HLineInvert:
; first
	XOR	ES:[DI], AX

	INC  DI
	INC  DI

; middle
  MOV  CX, DX	; CX := # words in middle
  JCXZ HLineInvertLastWord

	MOV	AX, 0FFFFH

HLineInvertMiddleLoop:
	XOR	ES:[DI], AX
	INC	DI
	INC	DI
	LOOP	HLineInvertMiddleLoop

HLineInvertLastWord:
  OR   BX, BX	; is last word (BX) = 0
  JZ   HLineBottomOfLoop

  XOR  ES:[DI], BX
	JMP	SHORT HLineBottomOfLoop


HLineErase:
; first
	NOT	AX
	AND	ES:[DI], AX

	INC  DI
	INC  DI

; middle
  MOV  CX, DX	; CX := # words in middle
  JCXZ HLineEraseLastWord

	XOR	AX, AX
	REP	STOSW

HLineEraseLastWord:
  OR	BX, BX	; is last word (BX) = 0
  JZ   HLineBottomOfLoop

	NOT	BX
  AND  ES:[DI], BX
	NOT	BX
	JMP	SHORT HLineBottomOfLoop


HLineDraw:
; first
	OR	ES:[DI], AX

	INC  DI
	INC  DI

; middle
  MOV  CX, DX	; CX := # words in middle
  JCXZ HLineDrawLastWord

	MOV	AX, 0FFFFH
	REP	STOSW

HLineDrawLastWord:
  OR   BX, BX	; is last word (BX) = 0
  JZ   HLineBottomOfLoop

  OR	ES:[DI], BX
;	JMP	SHORT HLineBottomOfLoop


; This is the common end for all cases (Draw, Erase, Invert & Fill)

HLineBottomOfLoop:
  MOV  AL, loc.oddLineFlag	; get buffer flag
  INC  AX	; next line
  AND  AL, 3	; IF AX = 4 (last buffer) THEN
	JNZ	HLineNextBuffer

  ADD  SI, loc.bplLessRewind	; go back to top
  JMP  SHORT HLineEndLoop

HLineNextBuffer:
  ADD  SI, loc.windowHeight	; go to next buffer
  CMP  AL, loc.edge
  JA   HLineEndLoop

  ADD  SI, loc.bytesPerLine

HLineEndLoop:
  MOV  loc.oddlineFlag, AL
  POP  CX	; get current count
  LOOP	HLineTopOfLoop	; do next one

HLineExit:
%IF (%supportsEmsWindows EQ 1) THEN (
  POP  AX	; Restore EMS slot
  INC  AX
  JZ   HLineExitHere

  DEC  AX
  CALL RestoreEmsSlot
) FI

HLineExitHere:
  MOV  SP, BP
  POP  BP
  POP  DS
  RET  paramBytes
$EJECT

; The pattern options are down here so the main routines (Draw, Erase, Invert)
; can have a smaller loop and will be a little bit faster.

; Caution: This assumes that DI=SI here (which is the case, now)

; start by figuring out which part of the pattern to use for this line

HLinePtnRtns:
	MOV	DI, loc.curPtnOffset
	MOV	CL, BYTE PTR [BP-localBytes+DI].ptnByte1
	MOV	CH, CL
	MOV	loc.curPattern, CX
	INC	DI
	AND	DI, 7
	MOV	loc.curPtnOffset, DI

	MOV	DI, SI	; Reset destination index
	JMP  loc.hLinePtnRtn

HLinePtnMerge:
; first word

	AND	AX, CX
	OR	ES:[DI], AX

	INC  DI
	INC  DI

; middle
  MOV  CX, DX	; CX := # words in middle
  JCXZ HLinePtnMergeLastWord

	MOV	AX, loc.curPattern

HLinePtnMergeMiddleLoop:
	OR	ES:[DI], AX
	INC	DI
	INC	DI
	LOOP	HLinePtnMergeMiddleLoop

HLinePtnMergeLastWord:
  OR   BX, BX	; is last word (BX) = 0
  JZ   HLineBottomOfLoop

	MOV	AX, BX
	AND	AX, loc.curPattern
	OR	ES:[DI], AX

	JMP	SHORT HLineBottomOfLoop


HLinePtnInvert:
; first word

	AND	AX, CX
	XOR	ES:[DI], AX

	INC  DI
	INC  DI

; middle
  MOV  CX, DX	; CX := # words in middle
  JCXZ HLinePtnInvertLastWord

	MOV	AX, loc.curPattern

HLinePtnInvertMiddleLoop:
	XOR	ES:[DI], AX
	INC	DI
	INC	DI
	LOOP	HLinePtnInvertMiddleLoop

HLinePtnInvertLastWord:
  OR   BX, BX	; is last word (BX) = 0
  JZ   HLinePtnInvertDone

	MOV	AX, BX
	AND	AX, loc.curPattern
	XOR	ES:[DI], AX

HLinePtnInvertDone:
	JMP	SHORT HLineBottomOfLoop


HLinePtnErase:
; first word

	AND	AX, CX
	NOT  AX
	AND	ES:[DI], AX

	INC  DI
	INC  DI

; middle
  MOV  CX, DX	; CX := # words in middle
  JCXZ HLinePtnEraseLastWord

	MOV	AX, loc.curPattern
	NOT	AX

HLinePtnEraseMiddleLoop:
	AND	ES:[DI], AX
	INC	DI
	INC	DI
	LOOP	HLinePtnEraseMiddleLoop

HLinePtnEraseLastWord:
  OR   BX, BX	; is last word (BX) = 0
  JZ   HLinePtnEraseDone

	MOV	AX, BX
	AND	AX, loc.curPattern
	NOT  AX
	AND	ES:[DI], AX

HLinePtnEraseDone:
	JMP	SHORT HLineBottomOfLoop

HLinePtnDraw:
; first word

	NOT	AX
	AND	ES:[DI], AX
	NOT	AX
	AND	AX, CX	; Line from pattern above
	OR	ES:[DI], AX

	INC  DI
	INC  DI

; middle
  MOV  CX, DX	; CX := # words in middle
  JCXZ HLinePtnDrawLastWord

	MOV	AX, loc.curPattern
	REP	STOSW

HLinePtnDrawLastWord:
  OR   BX, BX	; is last word (BX) = 0
  JZ   HLinePtnDrawDone

	MOV	AX, BX
	NOT	AX
	AND	ES:[DI], AX
	MOV	AX, BX
	AND	AX, loc.curPattern
	OR	ES:[DI], AX

HLinePtnDrawDone:
	JMP	SHORT HLineBottomOfLoop
ScrHLineRoutine ENDP

  PURGE params
  PURGE oldBP
  PURGE returnIP
  PURGE returnCS
  PURGE w
  PURGE x
  PURGE y
  PURGE screen
  PURGE localBytes
  PURGE loc
  PURGE paramBytes
  PURGE bytesPerLine
  PURGE windowHeight
  PURGE numLines
	PURGE hLineVerb
  PURGE oldDS
  PURGE oddLineFlag
  PURGE edge
  PURGE rewindDelta
	PURGE bplLessRewind
	PURGE curPtnOffset
	PURGE curPattern
	PURGE hLineRoutine
	PURGE hLinePtnRtn
	PURGE ptnByte1, ptnByte2, ptnByte3, ptnByte4
	PURGE ptnByte5, ptnByte6, ptnByte7, ptnByte8


CODE ENDS

  END
